;
; Pierre BETTENS PBT
;
; ================================================================
; LASex11.asm - Cours ASM - Redirection d'interruption -2001-2002
;
; Auteur        : PBT
; Date          : 7 Mars 2002
; Description   : Exemple de redirection base sur l'exercice
;                 'feu d'artifice' d'une annee precedente.
; ATTENTION     : Ce programme n'affiche pas de feu d'artifice !
; Idee d'enonce : Jean-Claude JAUMAIN
; Idee de redirection d'interruption 
;               : Jean-Marie VAN LOOCK
;  But : Creer un feu d'artifice a l'ecran ... le but maintenant 
;        est d'illustrer la redirection d'une interruption.
;
;  Le programme utilise la redirection de l'INT 1Ch. Cette 
;  interruption est appelee par le systeme 18 fois par seconde.
;  Il suffit de rediriger cette interruption vers notre propre
;  routine pour etre certain que le travail de la procedure sera 
;  effectue 18 fois par seconde.
;
.model small
.stack 100h
LOCALS
.486

; ================================================================
;   Declaration des macros
; ================================================================

;  ---------------------------------------------------------------
; mode n - Passe en mode video n
; ----------------------------------------------------------------
Mode    MACRO   n
        PUSH    AX
        MOV     AL,n
        MOV     AH,00h
        INT     10h
        POP     AX
ENDM    Mode

; -----------------------------------------------------------------
; attendre - Attend l'appui sur une touche 
; -----------------------------------------------------------------
Attendre        MACRO
  PUSHa
@@st:
  MOV   AH,1
  INT   16h
  JNZ   @@fin
  JMP   @@st
@@fin:
  POPa
ENDM    Attendre

; ================================================================
;   Declaration des constantes, variables et donnees
; ================================================================
.data
; ------------------------ Variable ------------------------------
  ;  Variable qui stocke l'adresse de int 1C     
  Routine1Ch      DW      ?,?

; ------------------------- Constantes ----------------------------
  bye       DB      10,13,13      
            DB      'ASM - Cours d''assembleur - '
            DB      'Janvier 2002','$'

; =================================================================
; Programme principal
; =================================================================
.code
main PROC 
  ; -------------------- Intro ------------------
  MOV   AX,@data
  MOV   DS,AX

  ; -------------------- Programme --------------
  mode 03h
  CALL  Rediriger1Ch
  Attendre
  ;  La redirection de l'int 1C appelle la procedure maRoutine
  CALL  Restaurer1Ch

  ; -------------------- Epilogue ---------------
  MOV   DX,offset bye
  MOV   AH,09h
  INT   21h
  MOV   AX,4C00h
  INT   21h
main  ENDP

; ================================================================
; Definitions des procedures et fonctions
; ================================================================

; ----------------------------------------------------------------
; Rediriger1Ch
;       Modifie l'adresse de int 1Ch afin 
;       d'appeler ma procedure Feu 18 fois
;       par seconde.
;       Uses: INT 21h,35h et INT 21h,25h
; -----------------------------------------------------------------
Rediriger1Ch    PROC
  PUSHad
  MOV   AX,351Ch
  INT   21h
  ; lit l'adresse de l'ancienne INT
  MOV   Routine1Ch,BX
  MOV   Routine1Ch+2,ES
  MOV   DX,offset maRoutine
  PUSH  DS
  PUSH  CS
  POP   DS
  MOV   AX,251Ch
  INT   21h
  POP   DS
  POPad
  RET
Rediriger1Ch    ENDP

; -----------------------------------------------------------------
; restaurer1Ch 
;       Ramene l'adresse de l'ancienne INT pour
;       qu'elle soit executee.
;       Uses : INT 21h,25h
;
Restaurer1Ch    PROC
  PUSHad
  PUSH  DS
  LDS   DX,dword ptr Routine1Ch
  ; Load using DS, DS est affecte
  MOV   AX,251Ch
  INT   21h
  POP   DS
  POPad
  RET
Restaurer1Ch    ENDP

; -----------------------------------------------------------------
; maRoutine - Ecrit ! a l'ecran
;
; Use    : int 21h,02h
; -----------------------------------------------------------------
maRoutine PROC
  PUSH  DX
  PUSH  AX
  MOV   AX,@data
  MOV   DS,AX
  ; La redirection de l'int modifie DS !  
  MOV   DL,'!'
  MOV   AH,02h
  INT   21h
  POP   AX
  POP   DX
  ; On ne retourne pas au pgm,
  ; on execute l'int 1Ch
  JMP   dword ptr Routine1Ch
  RET           ; pour faire beau
maRoutine ENDP
END     MAIN
