;
; Pierre BETTENS PBT
;
; ================================================================
; LASex2.asm - Cours ASM - Tri Bulle -2001-2002
;
; Auteur        : JMV-JCJ-PBT
; Date          : 8 Janvier 2002
; Description   : Effectue le tri bulle d'une chaine de 
;                 caracteres definie dans le segment data.
; ================================================================
.model small
.stack 100h
.486
JUMPS
; ================================================================
;   Declaration des constantes, variables et donnees
; ================================================================
.data
; ---------------------- Constantes ------------------------------
  ; Chaine de caracteres a trier et sa longueur
  tabl          DB      'La chaine a trier',10,13,'$'
  longueur      DW      $-tabl
	
  bye           DB      10,13      
		DB      'ASM - Cours d''assembleur - '
		DB      'Janvier 2002','$'


; ================================================================
; Programme principal 
; ================================================================
.code
  
  MAIN  PROC
  ; -------------------- Intro ------------------
  MOV   AX,@data
  MOV   DS,AX

  ; -------------------- Programme --------------
  ; Affichage de la chaine non triee
  MOV   DX,offset tabl
  MOV   AH,09h
  INT   21h

  ; Invariants :        DX : indice avt dernier elt 
  ;                     BL : boleen permutation O/N ?
  ;                     SI : indice de la boucle for
  MOV   DX,longueur
  SUB   DX,4
@@repeter:  
  SUB   BL,BL           ; BL = faux
  SUB   SI,SI           
  MOV   CX,DX
@@pour:
  MOV   AX,word ptr tabl[SI]     ; 2 caracteres (2*1byte=1Word)
@@si:
  CMP   AH,AL
  JAE   @@sinon
@@alors:
  MOV   BL,1            ; BL = vrai
  XCHG  AL,AH
  MOV   word ptr tabl[SI],AX
@@sinon:
  INC   SI
  LOOP  @@pour
  DEC   DX
@@jusqua:
  CMP   BL,0
  JNE   @@repeter

  ; Affichage de la chaine triee
  MOV   DX,offset tabl
  MOV   AH,09h
  INT   21h  

  ; -------------------- Epilogue ---------------
  MOV   DX,offset bye
  MOV   AH,09h
  INT   21h
  MOV   AX,4C00h
  INT   21h
  MAIN  ENDP
END MAIN
