;
; Pierre BETTENS PBT
;
; ================================================================
; LASex10.asm - Cours ASM - Redirection d'interruption -2001-2002
;
; Auteur        : PBT
; Date          : 7 Mars 2002
; Description   : Redirection de l'INT 23 vers maRoutine.
;                 L'INT 23 est la routine executee lors d'un
;                 [ctrl]-C.
; Effet         : Si Q, le programme s'arrete
;                 Si [ctrl]-C, affichage d'un message
; Use           : Utilisation des interruption int 21h,35h et
;                 int 21h,25h
; Limitation    : Le programme n'empeche pas l'afficahge du ^C
; ================================================================
.model small
.stack 100h
.486
LOCALS
JUMPS
; ================================================================
;   Declaration des constantes, variables et donnees
; ================================================================
.data
; ---------------------- Constantes ------------------------------
  bye       DB      10,13,13      
            DB      'ASM - Cours d''assembleur - '
            DB      'Janvier 2002','$'

  message   DB      10,13,'Non, non, pas de [ctrl]-C ','$'

; ----------------------- Variables  ------------------------------
  adresseOld    DW      ?,?


; ================================================================
; Programme principal 
; ================================================================
.code 
main PROC 
  ; -------------------- Intro ------------------
  MOV   AX,@data
  MOV   DS,AX

  ; -------------------- Programme --------------
  ; Sauvegarde de l'adresse de la routine [ctrl]-C
  MOV   AX,3523h
  INT   21h
  MOV   adresseOld,BX
  MOV   adresseOld[2],ES

  ; Redirection de la routine int 23h vers ma procedure
  MOV   AX,2523h
  MOV   DX,offset maRoutine
  PUSH  DS
  PUSH  CS
  POP   DS
  INT   21h
  POP   DS

  ; Attente de l'appui sur la touche Q
@@attend:
  MOV   AH,01h
  INT   21h
  CMP   AL,'Q'
  JNE   @@attend

  ; Restauration de la routine int 23h
  ; Cette restauration est facultative, DOS le fait
  ; pour nous lorsque l'on rend la main.
  PUSH  DS
  LDS   DX,dword ptr adresseOld
  MOV   AX,2523h
  INT   21h
  POP   DS

  ; -------------------- Epilogue ---------------
  MOV   DX,offset bye
  MOV   AH,09h
  INT   21h
  MOV   AX,4C00h
  INT   21h
main  ENDP

; ================================================================
; Definitions des procedures et fonctions
; ================================================================

; ----------------------------------------------------------------
; maRoutine  - Affichage d'un message a l'ecran
;
; Date          : 20 Fevrier 2002
; Description   : int 21h,09h pour afficher un message a l'ecran
;                 aucun registre n'est modifie
; ----------------------------------------------------------------
maRoutine PROC
  PUSHa
  MOV   AH,09h
  MOV   DX,offset message
  INT   21h
  POPa
  IRET
maRoutine ENDP

END MAIN
