;
; Pierre BETTENS PBT
;
; ================================================================
; LASex8.asm - Cours ASM - recurcivite-2001-2002
;
; Auteur        : PBT
; Date          : 20 Fevrier 2002
; Description   : Calcul de la factorielle d'un nombre de maniere 
;                 recurcive.
; ================================================================
.model small
.stack 100h             ; La pile est-elle assez grande pour
                        ; les calculs que vous voulez faire ?
.486
JUMPS
LOCALS			
; ================================================================
;   Declaration des constantes, variables et donnees
; ================================================================
.data
; ---------------------- Constantes ------------------------------
  bye       DB      10,13,13      
            DB      'ASM - Cours d''assembleur - '
            DB      'Janvier 2002','$'

  reponse   DB      'La factorielle de    est                  ','$'
  LREPONSE  EQU     $-reponse-2
  LQUESTION EQU     19

; ---------------------- Variables  ------------------------------
  FACTDE    EQU     12          ; maximum 12

; ================================================================
; Programme principal 
; ================================================================
.code
  
main PROC
  ; -------------------- Intro ------------------
  MOV   AX,@data
  MOV   DS,AX

  ; -------------------- Programme --------------
  MOV   SI,offset reponse
  ADD   SI,LQUESTION
  MOV   AX,FACTDE
  CALL  remplirChaine

  PUSH  FACTDE
  CALL  factorielle

  MOV   SI,offset reponse
  ADD   SI,LREPONSE
  CALL  remplirChaine

  MOV   DX,offset reponse
  MOV   AH,09h
  INT   21h

  ; -------------------- Epilogue ---------------
  MOV   DX,offset bye
  MOV   AH,09h
  INT   21h
  MOV   AX,4C00h
  INT   21h
main  ENDP

; ================================================================
; Definitions des procedures et fonctions
; ================================================================

; ----------------------------------------------------------------
; factorielle - Calcul la factorielle de n (rcurcif)
;
; Date          : 20 Fevrier 2002
; Descritption  : Calcul la factorielle du nombre place sur
;                 la pile.
;                 Methode recurcive.
; in            : PILE : 1 nombre
; out           : EAX contient la factorielle
; ----------------------------------------------------------------
factorielle PROC
  PUSH	BP
  MOV   BP,SP
  PUSH  EBX
  PUSH  EDX
  MOV   EAX,1
  CMP   AX,[BP+4]
  JE    @@si
@@sinon:
  MOV   BX,[BP+4]
  DEC   BX
  PUSH  BX
  CALL  factorielle
  MOVSX EBX,word ptr [BP+4]
  MUL   EBX
  ; saut finsi
@@si:                     ; la factorielle vaut 1 -> AX=1 deja fait
@@finsi:
  POP   EDX
  POP   EBX
  POP	BP
  RET   2
factorielle ENDP

; ----------------------------------------------------------------
; remplirChaine - Convertion en chaine de caractre
;
; Date          : 7 Mars 2002
; Description   : Convertit le nombre contenu ds AX en chaine
;                 de caracteres. Methode recurcive.
; IN            : SI : Offset de l'endroit ou placer le chiffre des
;                 unite 
;                 AX : Nombre a convertir
; Remarque      : Modifie AX et SI
; ----------------------------------------------------------------
remplirChaine PROC
  PUSH  DX
  PUSH  BX
  CMP   AX,10
  JAE   @@sinon
@@si:
  ADD   AX,'0'
  MOV   [SI],AL         ; code ascii = 1 byte
  JMP   @@finsi
@@sinon:
  MOV   BX,10
  MOV   DX,0
  IDIV   BX
  ADD   DX,'0'
  MOV   [SI],DL
  DEC   SI
  CALL  remplirChaine
@@finsi:
  POP   BX
  POP   DX  
  RET
remplirChaine ENDP


END MAIN
