;
; Pierre BETTENS PBT
;
; ================================================================
; LASex18.asm - Cours ASM - co-processeur  -2001-2002
;
; Auteur	: JMV-JCJ-PBT
; Date		: 8 Mars 2002
; Description	: Utilisation de macros
; ================================================================
.model small
.stack 100h
.486
JUMPS
LOCALS
; ================================================================
; Dclaration et dfinition de macros
; ================================================================

; ----------------------------------------------------------------
; mult_16 - Multiplie AX par 16
; ----------------------------------------------------------------
mult_16   MACRO
  ;  Commentaire visible
  ;; Commentaire invisible
  shl	  AX,1
  shl	  AX,1
  shl	  AX,1
  shl	  AX,1
ENDM	  mult_16

; ----------------------------------------------------------------
; mult_16bis - Idem avec l'instruction rept
; ----------------------------------------------------------------
mult_16bis  MACRO
  rept	    4
  shl	    AX,1
  endm
ENDM	   mult_16bis

; ----------------------------------------------------------------
; mult - Multiplie par un multiple de 2 pass en argument
; ----------------------------------------------------------------
mult MACRO  n
  rept	    n
  shl	    AX,1
  endm
ENDM  mult

; ----------------------------------------------------------------
; mult2 - Idem mult avec vrification des arguments
; ----------------------------------------------------------------
mult2  MACRO n
  ifb	     <n>
	     err  ;;
	     display "Nombre de repetitions absent"
  else
	     rept      n
	     shl       AX,1
	     endm
  endif
ENDM   mult2

; ----------------------------------------------------------------
; isWord - Positionne flag  1 si = AX,BC,CX ou DX
; ----------------------------------------------------------------
isWord	 MACRO	reg
  flag = 0
  ifidni  <reg>,<ax>
    flag=1
  elseifidni <reg>,<bx>
    flag=1
  elseifidni <reg>,<cx>
    flag=1
  elseifidni <reg>,<dx>
    flag=1
  endif
ENDM   isWord

; ----------------------------------------------------------------
; lShift - Excute shl,n
; ----------------------------------------------------------------
lShift	MACRO  reg, n
  ifb	<reg>
    err
    display "Quel registre ?"
  endif
  ifb  <n>
    err
    display "Donner le nombre de rpetitions"
  endif
  isWord    reg
  if flag
    rept    n
    shl     reg,1
    endm
  else
    err
    display "Ce n'est pas un registre 16 bits"
  endif
ENDM   lShift

; ----------------------------------------------------------------
; lShift2 - Idem avec paramtres par dfaut
; ----------------------------------------------------------------
lShift2  MACRO	reg, n
  ifb	<reg>
    err
    display "Quel registre ?"
    exitm
  elseifb  <n>
    shl    reg,1
  else
    rept    n
    shl     reg,1
    endm
  else
    err
    display "Ce n'est pas un registre 16 bits"
  endif
ENDM   lShift2

; ----------------------------------------------------------------
; test - Test de l'operateur %
; ----------------------------------------------------------------
test  MACRO  argument
  ifb <argument>
    display "Pas de parametre"
  elseifidni	 <argument>,<"Hello">
    display "Bonjour = Hello"
  elseifidni	 <argument>,<"Bye">
    display "Au revoir = bye"
  else
    display "Je ne comprends pas"
  endif
ENDM   test

; ----------------------------------------------------------------
; isUpper - Utilisation des labels locaux
;
; Description : Si le registre reg contient une lettre majuscule
;		le flag Z est positionne a 1
; ----------------------------------------------------------------
isUpper  MACRO	reg
local non	   ;; signale que le label est local
  ifnb	 <reg>
  cmp	 reg,'A'
  jb	 non
  cmp	 reg,'Z'
  ja	 non
  cmp	 reg,reg   ;; positionne ZF=1
  endif
non:
 ENDM	 isUpper



; ================================================================
;   Declaration des constantes, variables et donnees
; ================================================================
.data
; ---------------------- Constantes ------------------------------
  bye		DB	10,13
		DB	'ASM - Cours d''assembleur - '
		DB	'Janvier 2002','$'

  bj		EQU	"Hello"

; ================================================================
; Programme principal
; ================================================================
.code

main PROC
  ; -------------------- Intro ------------------
  MOV	AX,@data
  MOV	DS,AX

  ; -------------------- Programme --------------
  MOV	AX,1
  mult_16
  MOV	AX,1
  mult_16bis
  MOV	AX,1
  mult
  MOV	AX,1
  mult	3
  MOV	AX,1
  mult2 3
;  MOV	 AX,1
;  mult2

  MOV	 AX,24
  lShift CX,2
  isword CX
;  lShift AX
  isWord AX
;  lShift AL,2
;  isword AL

  lShift2 CX,2
  lShift2 AX
;  lShift2

  test	  "Hello"
  test	  %bj
  test	  "bye"
  test

  MOV	  AL,'B'
  isUpper AL
  isUpper
  MOV	  AL,'c'
  isUpper AL



  ; -------------------- Epilogue ---------------
  MOV	DX,offset bye
  MOV	AH,09h
  INT	21h
  MOV	AX,4C00h
  INT	21h
main  ENDP

END MAIN
