;
; Pierre BETTENS PBT
;
; ================================================================
; LASex17.asm - Cours ASM - co-processeur  -2001-2002
;
; Auteur        : JMV-JCJ-PBT
; Date          : 8 Mars 2002
; Description   : Exemple d'utilisation du co-processeur math.
;                 Comparer PI et 22/7
; ================================================================
.model small
.stack 100h
.486
JUMPS
LOCALS           
; ================================================================
;   Declaration des constantes, variables et donnees
; ================================================================
.data
; ---------------------- Constantes ------------------------------
  bye           DB      10,13      
		DB      'ASM - Cours d''assembleur - '
                DB      'Janvier 2002','$'

  _22           DQ      22              ; constantes (DQ car on peut)
  _7            DW      7

; ================================================================
; Programme principal 
; ================================================================
.code
  
main PROC
  ; -------------------- Intro ------------------
  MOV   AX,@data
  MOV   DS,AX

  ; -------------------- Programme --------------
  CALL  calcul

  ; -------------------- Epilogue ---------------
  MOV   DX,offset bye
  MOV   AH,09h
  INT   21h
  MOV   AX,4C00h
  INT   21h
main  ENDP

; ================================================================
; Definitions des procedures et fonctions
; ================================================================

; -----------------------------------------------------------------
; calcul - Comparer PI et 22/7
;
; Entre       : _22 et _7
; Sortie       : AL contient '<' ou '>' ou '='
; Modifie      : St
; ------------------------------------------------------------------
calcul PROC
  FINIT

  FLDPi
  FILD          _22
  FIDIV         _7
  FCOMPP        St(1)   ; compare St(0) et St(1) et POP POP
  FSTSW         AX      ; charge dans AX le Status Word
  SAHF                  ; Store AH into Flags
  JA            @@plusgrand
  JB            @@pluspetit
@@egal:
  MOV           AL,'='
  JMP           @@fintest
@@plusgrand:
  MOV           AL,'>'
  JMP           @@fintest
@@pluspetit:
  MOV           AL,'<'
@@fintest:
  RET
calcul ENDP

END MAIN
