;
; Pierre BETTENS PBT
;
; ================================================================
; LASex16.asm - Cours ASM - co-processeur  -2001-2002
;
; Auteur        : JMV-JCJ-PBT
; Date          : 8 Mars 2002
; Description   : Exemple d'utilisation du co-processeur math.
;                 convertir une vitesse donnee en km/h en m/s
; ================================================================
.model small
.stack 100h
.486
JUMPS
LOCALS           
; ================================================================
;   Declaration des constantes, variables et donnees
; ================================================================
.data
; ---------------------- Constantes ------------------------------
  bye           DB      10,13      
		DB      'ASM - Cours d''assembleur - '
                DB      'Janvier 2002','$'
  _1000         DW      1000
  _3600         DW      3600

; ---------------------- Variables --------------------------------
  kmh           DW      60              ; vitesse en km/h
  ms            DW      ?               ; vitesse en m/s 
 
; ================================================================
; Programme principal 
; ================================================================
.code
  
main PROC
  ; -------------------- Intro ------------------
  MOV   AX,@data
  MOV   DS,AX

  ; -------------------- Programme --------------
  CALL  calcul

  ; -------------------- Epilogue ---------------
  MOV   DX,offset bye
  MOV   AH,09h
  INT   21h
  MOV   AX,4C00h
  INT   21h
main  ENDP

; ================================================================
; Definitions des procedures et fonctions
; ================================================================

; -----------------------------------------------------------------
; calcul - Conversion d'une vitesse ne m/s
;
; Description  : hm/h -> m/s
; Entre       : kmh
; Sortie       : ms
; Modifie      : St
; ------------------------------------------------------------------
calcul PROC
  FINIT

  ; Calcul sur des reels
  FILd  _1000
  FILD  kmh
  FMUL
  FILD  _3600
  FDIV
  FISTP ms

  ; Deuxieme methode, calcul sur les entiers
  FILD  kmh
  FIMUL _1000
  FIDIV _3600
  FISTP ms

  RET
calcul ENDP

END MAIN
