;
; Pierre BETTENS PBT
;
; ================================================================
; LASex15.asm - Cours ASM - co-processeur  -2001-2002
;
; Auteur	: JMV-JCJ-PBT
; Date		: 8 Mars 2002
; Description	: Exemple d'utilisation du co-processeur math.
;		  Calcul de la racine carre de x avec le 80x87
;		  et avec la formule de recurence
;		  r(x)=(x/r(x)+r(x))/2
; ================================================================
.model small
.stack 100h
.486
JUMPS
LOCALS		 
; ================================================================
;   Declaration des constantes, variables et donnees
; ================================================================
.data
; ---------------------- Constantes ------------------------------
  bye		DB	10,13	   
		    DB	    'ASM - Cours d''assembleur - '
		DB	'Janvier 2002','$'
  _2		DW	2

; ---------------------- Variables --------------------------------
  x		DW	169		; on evalue pour x
  r1		DT	?
  dr		DT	?


  
; ================================================================
; Programme principal 
; ================================================================
.code
  
main PROC
  ; -------------------- Intro ------------------
  MOV	AX,@data
  MOV	DS,AX

  ; -------------------- Programme --------------
  CALL	calcul

  ; -------------------- Epilogue ---------------
  MOV	DX,offset bye
  MOV	AH,09h
  INT	21h
  MOV	AX,4C00h
  INT	21h
main  ENDP

; ================================================================
; Definitions des procedures et fonctions
; ================================================================

; -----------------------------------------------------------------
; calcul - Calcul d'une racine carree
;
; Description  : Calcul de la racine carre
;		 R(X) = (X/R(X) + R(X))/2
;		 stop ds que la difference entre deux valeurs
;		 successives < 2^(-32)
; Entre       : x,_2
; Sortie       : r1 = valeur intermdiaire
; Modifie      : St
; ------------------------------------------------------------------
calcul PROC
	PUSH	AX
	PUSH	DI
	FINIT				; initialise
	; Calcul immediat de la racine carree
	FILD	x
	FSQRT

	; Calcul avec formule de recurrence
	FLD1				;
	FSTP	R1			; R1<-1
	MOV	DI,Offset DR

@@1:	FLD	R1			; R1
	FLD	St(0)			; doubl
	FILD	X			; x
	FLD	R1			; R1
	FDIV				; x/R1
	FADD				; x/R1 + R1
	FILD	_2			; 2
	FDIV				; divise par 2
	FLD	St(0)			; doubl
	FSTP	R1			; R1 en mmoire
	FSUB				; diffrence de 2 R1 successifs
	FSTP	DR			; DR la diffrence
	MOV	AX,[DI+8]		; l'exposant de la diffrence
					; Pq [DI+8] ? A cause de l'inversion d'Intel
	AND	AX,7FFFh		; enlve le signe
	CMP	AX,3FDFh		; si >= 2^-32
	JGE	@@1			;  alors continue
					;  sinon fini
	POP	DI
	POP	AX
	RET
calcul ENDP

END MAIN
