;
; Pierre BETTENS PBT
;
; ================================================================
; LASex13.asm - Cours ASM - co-processeur  -2001-2002
;
; Auteur        : JMV-JCJ-PBT
; Date          : 8 Mars 2002
; Description   : Exemple d'utilisation du co-processeur math.
;                 Calcul de 10 000 * sin2(x/10 000) et
;                 10 000 * cos2(x/10 000).
;                 On remarque que la somme des deux fait 10 000.          
; ================================================================
.model small
.stack 100h
.486
JUMPS
LOCALS           
; ================================================================
;   Declaration des constantes, variables et donnees
; ================================================================
.data
; ---------------------- Constantes ------------------------------
  bye           DB      10,13      
		DB      'ASM - Cours d''assembleur - '
		DB	  'Janvier 2002','$'

  v1000         DW      1000
  V10000        DW      10000

; ---------------------- Variables --------------------------------
  x             DW      169             ; on evalue pour x
  cWord         DW      ?               ; modification de CW
  c2x           DW      ?               ; cos2x
  s2x           DW      ?               ; sin2x
  
; ================================================================
; Programme principal 
; ================================================================
.code
  
main PROC
  ; -------------------- Intro ------------------
  MOV   AX,@data
  MOV   DS,AX

  ; -------------------- Programme --------------
  CALL  calcul

  ; -------------------- Epilogue ---------------
  MOV   DX,offset bye
  MOV   AH,09h
  INT   21h
  MOV   AX,4C00h
  INT   21h
main  ENDP

; ================================================================
; Definitions des procedures et fonctions
; ================================================================

; -----------------------------------------------------------------
; calcul - Constater que s2x + c2x = 10000
;
; Description  : Calcul de S2X = 10000*sin(x/1000),
;                C2X = 10000*cos(x/1000)
; Entre       : x,v1000,v10000
; Sortie       : S2X, C2X 
; Modifi      : St
; ------------------------------------------------------------------
calcul PROC
  FINIT
  FILD    X                               ; x/1000
  FILD    V1000
  FDIV
  FLD     St(0)                          
  FSIN                                    ; sin(x)
  FLD     St(0)                           ; doubl
  FMUL                                    ; multipli -> carr
  FILD    V10000                          ;
  FMUL                                    ; sin*10000
  FISTP   S2X                             ; mmoris et pop
  FCOS                                    ; cos(x)
  FLD     St(0)                           ; doubl
  FMUL                                    ; multipli -> carr
  FILD    V10000                   
  FMUL                                    ; cos*10000
  FISTP   C2X                             ; mmoris et pop
  RET
calcul ENDP

END MAIN
