;
; Pierre BETTENS PBT
;
; ================================================================
; LASCal.asm - Cours ASM - Calendrier du mois avec date du jour
;
; Auteur        : JMV-JCJ-PBT
; Date          : Examen de septembre 99
; Description   : Affiche un calendrier du mois en cours avec la
;                       date du jour.
; ================================================================
.MODEL SMALL
.STACK 100h
LOCALS
.486
; ================================================================
;   Declaration des constantes, variables et donnees
; ================================================================
.data
; ---------------------- Constantes ------------------------------
	Bye     DB      'Examen d''ASM',10,13
		DB      'Pierre BETTENS, Septembre 1999',10,13,'$' 

	; Initialise l'extra segment pour la memoire video
	INI     DW      0B800h

	; Coin superieur gauche du cadre
	Y       EQU     5
	X       EQU     25

	; Attribut pour l'ecriture dans la memoire video 
	; Deux bytes par caractres, 
	;  l'attribut (RVBfond-RVBchar-Clignote)
	;  et le code ascii du char
	Attribut EQU     00001111b

	Mois    DB      ' Janvier ',' Fevrier ','  Mars   '
		DB      '  Avril  ','   Mai   ','  Juin   '
		DB      ' Juillet ','  Ao-t   ','Septembre'
		DB      ' Octobre ','Novembre ','Dcembre '
	LMOIS   EQU     9
	Jours   DB      'Dimanche','Lundi   ','Mardi   ','Mercredi'
		DB      'Vendredi','Samedi  '
	LJOUR   EQU     8
	Cadre   DB      'Ŀ'
		DB      '                          '
		DB      'Ĵ'
		DB      'Di  Lu  Ma  Me  Je  Ve  Sa'
		DB      '                          '
		DB      '                          '
		DB      '                          '
		DB      '                          '
		DB      '                          '
		DB      '                          '
		DB      'Ĵ'
		DB      '                          '
		DB      ''
	LARGEUR EQU     28
	HAUTEUR EQU     12    ; en fait hauteur - 1

; ---------------------- Variables ------------------------------

	JSem    DB      ?       ; jour de la semaine courante Di=0, ..
	A       DW      ?       ; annee courante
	M       DB      ?       ; mois courant
	J       DB      ?       ; jour courant 1,2 ..
	Jour    DB      ?       ; utilisee par premierJour et dernierJour

; ================================================================
; Programme principal 
; ================================================================
.code
main    PROC
	MOV     AX,@data
	MOV     DS,AX
	  ; -------------------- Programme --------------
	  ;Mise en place de segment et CLS
	  MOV       ES,INI
	CALL    mode03

	CALL    lireDate
	CALL    dessinCadre
	CALL    ecrireCal
	  ; -------------------- Epilogue ---------------
	MOV     AH,00h
	INT     16h
	CALL    Mode03
	MOV     DX,offset Bye
	CALL    WMess
	MOV     AX,4C00h
	INT     21h
main    ENDP

; ----------------------------------------------------------------
; mode03 - Change le mode video
;
; Auteur        : PBT
; Desription: Change le mode video et/ou fait un cls en mode texte
;                 Aucun registre n'est modifi
; Use           : Int 10h,00h; 
; ----------------------------------------------------------------
mode03  PROC
	PUSH    AX
	MOV     AL,03h          ;passe en mode normal int 10h, service 00h
	MOV     AH,00h
	INT     10h
	POP     AX
	RET
mode03  ENDP

; ----------------------------------------------------------------
; lireDate - Lit la date systeme
;
; Auteur          : PBT
; Descritption: Lit la date systeme
;                   Aucun registre n'est modifi
; Uses    : int 21h,2Ah
; Return          : AL JourSem (0=Dim), CX Annee, DH Mois, DL Jour
; ----------------------------------------------------------------
lireDate        PROC
	PUSHa
	MOV     AX,2A00h
	INT     21h
	MOV     JSem,AL
	MOV     A,CX
	MOV     M,DH
	MOV     J,DL
	POPa
	RET
lireDate        ENDP

; ----------------------------------------------------------------
; dessinCadre - Dessine le cadre 
;
; Auteur          : PBT
; Descritption: Dessine le cadre definit dans les constantes 
;                   a la position X,Y
; Uses    : constante Cadre
;                   ES segment video (0B800h)
;                   Attribut, format des caracteres
; ----------------------------------------------------------------
dessinCadre     PROC
	PUSHa
	MOV     BX,Y*80*2+X*2
	  ; Invariants : DI indice dans le tableau Cadre
	  ;              SI indice ecran
	SUB     DI,DI
	SUB     SI,SI
	MOV     AH,Attribut
@@lp1:
	MOV     AL,[Cadre]+DI           ; caractere a ecrire
	MOV     ES:[BX+SI],AX           ; position du caractere
	INC     SI                      ; un caractere = 2 bytes
	INC     SI
	INC     DI
	  ; Test fin de ligne
	CMP     SI,LARGEUR*2
	JB      @@lp1
	  ; Passage a la ligne suivante
	SUB     SI,SI
	ADD     BX,80*2
	  ; Test fin du cadre
	CMP     DI,(LARGEUR+1)*HAUTEUR   
	JB      @@lp1
	POPa
	RET
dessinCadre     ENDP

; ----------------------------------------------------------------
; ecrireCal - Ecriture des elts du calendrier
;
; Auteur         : PBT
; Description: Ecriture du mois en haut, de la date complete 
;                  dans le bas et des jours au centre
; Uses   : ecrireMois, ecrireDate et remplirCal
; ----------------------------------------------------------------
ecrireCal       PROC
	CALL    ecrireMois
	CALL    ecrireDate
	CALL    remplirCal
	RET
ecrireCal       ENDP

; ----------------------------------------------------------------
; ecrireMois -Ecrit le mois en haut
;
; Uses    : Variable Mois
; ----------------------------------------------------------------
ecrireMois      PROC
	PUSHa
	  ; recherche de la bonne position dans Mois
	  ; BX pointera sur le premier char des 9 char du mois
	MOV     AL,M
	DEC     AL
	MOV     BL,AL
	SHL     BL,3
	ADD     BL,AL           ; pourquoi ?
	SUB     BH,BH
	ADD     BX,offset Mois
	  ; Invariants : DI indice des caracteres du mois dans Mois
	  ;                SI indice a l'ecran
	SUB     DI,DI
	SUB     SI,SI
@@lbl:
	MOV     AL,[BX+DI]
	MOV     AH,Attribut
	MOV     ES:[(Y+1)*80*2+(X+(LARGEUR-8)/2)*2+SI],AX
	INC     SI
	INC     SI
	INC     DI
	CMP     DI,LMOIS
	JB      @@lbl
	POPa
	RET        
ecrireMois      ENDP

; ----------------------------------------------------------------
; ecrireDate - ecrit la date en bas
;
; Auteur          : PBT
; Description : Ecrit la date sous la forme 
;                 JJJJJJJJ JJ MMMMMMMMM AAAA
; Uses    : Variables JSem, J, M, A
;                 Tableaux Jours et Mois
; ----------------------------------------------------------------
ecrireDate      PROC
	PUSHa
	  ; Meme methode que dans la procedure ecrireMois
	; ------------- Ecrire JSem -----------------
	MOV     BL,JSem
	SHL     BL,3
	SUB     BH,BH
	ADD     BX,offset Jours
	SUB     DI,DI
	SUB     SI,SI
@@lbl:
	MOV     AL,[BX+DI]
	MOV     AH,Attribut
	MOV     ES:[(Y+HAUTEUR-1)*80*2+(X+1)*2+SI],AX
	INC     SI
	INC     SI
	INC     DI
	CMP     DI,8
	JB      @@lbl
	; -------------- Ecrire JJ ------------------
	SUB     AH,AH
	MOV     AL,J                               
	MOV     CL,10
	DIV     CL
	MOV     CH,Attribut
	MOV     CL,AL
	MOV     AL,'0'  ;48
	ADD     CL,AL
	MOV     ES:[(Y+HAUTEUR-1)*80*2+(X+10)*2],CX
	MOV     CL,AH
	ADD     CL,AL
	MOV     ES:[(Y+HAUTEUR-1)*80*2+(X+11)*2],CX        
	; -------------- Ecrire Mois -----------------
	MOV     AL,M
	DEC     AL
	MOV     BL,AL
	SHL     BL,3
	ADD     BL,AL
	SUB     BH,BH
	ADD     BX,offset Mois
	SUB     DI,DI
	SUB     SI,SI
@@lb2:
	MOV     AL,[BX+DI]
	MOV     AH,Attribut
	MOV     ES:[(Y+HAUTEUR-1)*80*2+(X+13)*2+SI],AX
	INC     SI
	INC     SI
	INC     DI
	CMP     DI,9
	JB      @@lb2
	; -------------- Ecrire annee ----------------
	MOV     AX,A
	MOV     BL,10
	DIV     BL
	MOV     CH,Attribut
	MOV     BH,48
	MOV     CL,AH        
	ADD     CL,BH
	MOV     ES:[(Y+HAUTEUR-1)*80*2+(X+26)*2],CX
	SUB     AH,AH
	DIV     BL
	MOV     CL,AH
	ADD     CL,BH
	MOV     ES:[(Y+HAUTEUR-1)*80*2+(X+25)*2],CX
	SUB     AH,AH
	DIV     BL
	MOV     CL,AH
	ADD     CL,BH
	MOV     ES:[(Y+HAUTEUR-1)*80*2+(X+24)*2],CX
	SUB     AH,AH
	DIV     BL
	MOV     CL,AH
	ADD     CL,BH
	MOV     ES:[(Y+HAUTEUR-1)*80*2+(X+23)*2],CX
	POPa
	RET
ecrireDate      ENDP

; ----------------------------------------------------------------
; remplirCal - Remplit la partie centrale avec les nombres
;
; Auteur         : PBT
; Descritption   : Remplit la partie centrale.
; Uses           : Procedures trouverJour (premier jour du mois)
;                             dernierJour (28, 30, 31)
;                : Variable Jour, modifiee par trouverJour 
;                           et dernierJour
; ----------------------------------------------------------------
remplirCal      PROC
	PUSHa
	CALL    trouverJour
	MOV     DI,word ptr Jour
	DEC     DI                      ; indice commence a 0 et Jour a 1
	CALL    dernierJour             ; Jour contient dernierJour
	MOV     BX,(Y+4)*80*2+(X+1)*2
	MOV     AX,DI
	SHL     AX,3                    ; positionnement au bon 1er jour
	ADD     BX,AX
	MOV     DH,Attribut
	MOV     CH,1
	MOV     CL,10
@@lp:
	; j ecris deux chiffres 
	SUB     AH,AH
	MOV     AL,CH
	DIV     CL
	MOV     DL,AL
	ADD     DL,48
	MOV     ES:[BX],DX
	MOV     DL,AH
	ADD     DL,'0'
	ADD     BX,2
	MOV     ES:[BX],DX
	; je passe a la position suivante et au jour suivant
	ADD     BX,6
	INC     CH
	INC     DI
	; test retour a la ligne
	CMP     DI,7
	JB      @@lp
	SUB     DI,DI
	ADD     BX,104  
	MOV     AH,Jour
	SUB     AH,6
	CMP     CH,AH
	JB      @@lp
	CMP     CH,Jour
	JA      @@fin
	MOV     AL,CH
	MOV     AH,Jour
	SUB     AH,AL
	MOV     AL,7
	SUB     AL,AH
	SUB     AH,AH
	MOV     DI,AX
	DEC     DI
	JMP     @@lp
@@fin:
	POPa
	RET
remplirCal      ENDP

; ----------------------------------------------------------------
; trouverJour - Cherche le premier jour du mois
;
; Auteur         : PBT
; Description    : Cherche le premier jour du mois, 1/2/02=Jeudi
; Principe       : Modifier la date systeme avec le premier jour
;                  desire, memoriser le jour semaine, et restaurer
;                  la date initiale.
; Uses           : INT 21h 2B SetDate, INT 21h, 2A GetDate
;                  Variables J,M,A,Jour
; OUT            : Jour
; ----------------------------------------------------------------
trouverJour      PROC
	PUSHa
	MOV     DL,1
	MOV     DH,M
	MOV     CX,A
	MOV     AH,2Bh
	INT     21h             ;modifie la date systeme
	MOV     AH,2Ah
	INT     21h
	MOV     Jour,AL
	MOV     DL,J
	MOV     AH,2Bh
	INT     21h             ;retablit la date systeme
	POPa
	RET
trouverJour     ENDP

; ----------------------------------------------------------------
; dernierJour - Cherche le dernier jour du mois
;
; Auteur        : PBT
; Description   : Cherche le dernier jour du mois
; IN            : Variable M
; OUT           : Variable Jour
; Remarque      : Cette procedure ne tient pas compte des annees
;                 bissextiles
; ----------------------------------------------------------------
dernierJour     PROC
	PUSHa
	; Je suppose un mois de 31 jours
	; Apres juillet, les mois impairs ont 30 jours
	; Avant juillet, les mois pairs ont 30 jours
	MOV     Jour,31
	MOV     AL,M
@@si:   ; Avant Juillet
	CMP     AL,7
	JA      @@sinon
@@alors:
	SHR     AL,1
	JC      @@fsi
	MOV     Jour,30
	JMP     @@fsi
@@sinon:
	SHR     AL,1
	JNC     @@fsi
	MOV     Jour,30
@@fsi:
	; On traite fevrier mais pas les annees bissextiles
	CMP     M,2
	JNE     @@fin
	MOV     Jour,28
@@fin:
	POPa
	RET
dernierJour     ENDP

; ----------------------------------------------------------------
; WMESS - Ecrit un message a l ecran
;
; IN            : DX offset du message (termine par $)
; Use           : int 21h,09h
; ----------------------------------------------------------------
WMESS   PROC
	PUSH    AX      
	MOV     AH,09h  ;service 9 de l'interruption 21h
			;permet d'crire  l'cran
	INT     21h
	POP     AX      
	RET             
WMESS   ENDP

END Main
